/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.storage;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class GlobalSettings
implements INBTSerializable {
    @Deprecated
    public static final String LEGACY_FILENAME = "createrailwaysnavigator_global_settings.dat";
    public static final String FILENAME = "createrailwaysnavigator_global_settings.nbt";
    public static final int DATA_VERSION = 1;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_STATION_TAGS = "StationTags";
    private static final String NBT_TRAIN_GROUPS = "TrainGroups";
    private static final String NBT_STATION_BLACKLIST = "StationBlacklist";
    private static final String NBT_TRAIN_BLACKLIST = "TrainBlacklist";
    private static final String NBT_TRAIN_LINES = "TrainLines";
    private final MinecraftServer server;
    private final Map<UUID, StationTag> stationTags = new HashMap<UUID, StationTag>();
    private final Map<String, TrainGroup> trainGroups = new HashMap<String, TrainGroup>();
    private final Set<String> stationBlacklist = new HashSet<String>();
    private final Set<String> trainBlacklist = new HashSet<String>();
    private final Map<String, TrainLine> trainLines = new HashMap<String, TrainLine>();
    private static GlobalSettings instance;

    private GlobalSettings(MinecraftServer server) {
        this.server = server;
    }

    public static synchronized GlobalSettings getInstance() {
        if (instance == null) {
            try {
                instance = GlobalSettings.open(ModCommonEvents.getCurrentServer().get());
            }
            catch (IOException e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to open settings file.", (Throwable)e);
                instance = new GlobalSettings(ModCommonEvents.getCurrentServer().get());
            }
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.close();
        }
        instance = null;
    }

    public synchronized void save() {
        CompoundTag nbt = this.serializeNbt();
        try {
            NbtIo.m_128944_((CompoundTag)nbt, (File)new File(this.server.m_129843_(new LevelResource("data/createrailwaysnavigator_global_settings.nbt")).toString()));
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("Saved global settings.");
            }
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save global settings.", (Throwable)e);
        }
    }

    public static synchronized GlobalSettings open(MinecraftServer server) throws IOException {
        File legacyFile = new File(server.m_129843_(new LevelResource("data/createrailwaysnavigator_global_settings.dat")).toString());
        File settingsFile = new File(server.m_129843_(new LevelResource("data/createrailwaysnavigator_global_settings.nbt")).toString());
        GlobalSettings file = new GlobalSettings(server);
        if (legacyFile.exists()) {
            CreateRailwaysNavigator.LOGGER.warn("A legacy global settings file was found. Try to load it.");
            file.deserializeNbtLegacy(NbtIo.m_128937_((File)legacyFile).m_128469_("data"));
            legacyFile.delete();
        } else if (settingsFile.exists()) {
            file.deserializeNbt(NbtIo.m_128937_((File)settingsFile));
        }
        return file;
    }

    public synchronized CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_VERSION, 1);
        CompoundTag stationsComp = new CompoundTag();
        this.stationTags.entrySet().forEach(x -> stationsComp.m_128365_(((UUID)x.getKey()).toString(), (Tag)((StationTag)x.getValue()).toNbt()));
        nbt.m_128365_(NBT_STATION_TAGS, (Tag)stationsComp);
        CompoundTag trainGroupComp = new CompoundTag();
        this.trainGroups.entrySet().forEach(x -> trainGroupComp.m_128365_(((String)x.getKey()).toString(), (Tag)((TrainGroup)x.getValue()).toNbt()));
        nbt.m_128365_(NBT_TRAIN_GROUPS, (Tag)trainGroupComp);
        ListTag stationsBlacklist = new ListTag();
        this.stationBlacklist.forEach(x -> stationsBlacklist.add((Object)StringTag.m_129297_((String)x)));
        nbt.m_128365_(NBT_STATION_BLACKLIST, (Tag)stationsBlacklist);
        ListTag trainsBlacklist = new ListTag();
        this.trainBlacklist.forEach(x -> trainsBlacklist.add((Object)StringTag.m_129297_((String)x)));
        nbt.m_128365_(NBT_TRAIN_BLACKLIST, (Tag)trainsBlacklist);
        CompoundTag trainLinesComp = new CompoundTag();
        this.trainLines.entrySet().forEach(x -> trainLinesComp.m_128365_(((String)x.getKey()).toString(), (Tag)((TrainLine)x.getValue()).toNbt()));
        nbt.m_128365_(NBT_TRAIN_LINES, (Tag)trainLinesComp);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        int version = nbt.m_128451_(NBT_VERSION);
        CompoundTag stationsComp = nbt.m_128469_(NBT_STATION_TAGS);
        this.stationTags.putAll(stationsComp.m_128431_().stream().map(x -> StationTag.fromNbt(stationsComp.m_128469_(x), UUID.fromString(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        CompoundTag trainGroupsComp = nbt.m_128469_(NBT_TRAIN_GROUPS);
        this.trainGroups.putAll(trainGroupsComp.m_128431_().stream().map(x -> TrainGroup.fromNbt(trainGroupsComp.m_128469_(x))).collect(Collectors.toMap(x -> x.getGroupName(), x -> x)));
        this.stationBlacklist.addAll(nbt.m_128437_(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList());
        this.trainBlacklist.addAll(nbt.m_128437_(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList());
        CompoundTag trainLinesComp = nbt.m_128469_(NBT_TRAIN_LINES);
        this.trainLines.putAll(trainLinesComp.m_128431_().stream().map(x -> TrainLine.fromNbt(trainLinesComp.m_128469_(x))).collect(Collectors.toMap(x -> x.getLineName(), x -> x)));
    }

    @Deprecated
    private void deserializeNbtLegacy(CompoundTag nbt) {
        String NBT_ALIAS_REGISTRY = "RegisteredAliasData";
        String NBT_BLACKLIST = NBT_STATION_BLACKLIST;
        String NBT_TRAIN_BLACKLIST = NBT_TRAIN_BLACKLIST;
        String NBT_TRAIN_GROUP_REGISTRY = "RegisteredTrainGroups";
        List<Object> aliasData = new ArrayList();
        List<Object> trainGroupData = new ArrayList();
        List<Object> blacklistData = new ArrayList();
        List<Object> trainBlacklistData = new ArrayList();
        if (nbt.m_128441_("RegisteredAliasData")) {
            aliasData = nbt.m_128437_("RegisteredAliasData", 10).stream().map(x -> (CompoundTag)x).toList();
        }
        if (nbt.m_128441_("RegisteredTrainGroups")) {
            trainGroupData = nbt.m_128437_("RegisteredTrainGroups", 10).stream().map(x -> (CompoundTag)x).toList();
        }
        if (nbt.m_128441_(NBT_STATION_BLACKLIST)) {
            blacklistData = nbt.m_128437_(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList();
        }
        if (nbt.m_128441_(NBT_TRAIN_BLACKLIST)) {
            trainBlacklistData = nbt.m_128437_(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList();
        }
        LinkedHashSet usedIds = new LinkedHashSet();
        this.stationTags.putAll(aliasData.stream().map(x -> {
            UUID id;
            while (usedIds.contains(id = UUID.randomUUID())) {
            }
            usedIds.add(id);
            return StationTag.fromNbt(x, id);
        }).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        usedIds.clear();
        this.trainGroups.putAll(trainGroupData.stream().map(x -> TrainGroup.fromNbt(x)).collect(Collectors.toMap(x -> x.getGroupName(), x -> x)));
        this.stationBlacklist.addAll(blacklistData);
        this.trainBlacklist.addAll(trainBlacklistData);
        this.save();
    }

    public void close() {
        this.save();
    }

    public boolean hasStationTag(GlobalStation station) {
        return this.hasStationTag(station.name);
    }

    public boolean hasStationTag(String stationName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(String tagName) {
        return this.stationTagExists(TagName.of(tagName));
    }

    public boolean stationTagExists(TagName tagName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(UUID id) {
        return this.stationTags.containsKey(id);
    }

    public StationTag getOrCreateStationTagFor(GlobalStation station) {
        return this.getOrCreateStationTagFor(station.name);
    }

    public StationTag getOrCreateStationTagFor(TagName tagName) {
        return this.getTagByName(tagName).orElse(this.getOrCreateStationTagFor(tagName.get()));
    }

    public StationTag getOrCreateStationTagFor(String stationName) {
        if (stationName.contains("*")) {
            return this.getOrCreateTagForWildcard(stationName);
        }
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return tag;
        }
        return new StationTag(null, TagName.of(stationName), Map.of(stationName, StationTag.StationInfo.empty()));
    }

    private StationTag getOrCreateTagForWildcard(String stationName) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q") + "\\E";
        for (StationTag tag : this.stationTags.values()) {
            for (String name : tag.getAllStationNames()) {
                if (!name.matches(regex)) continue;
                return tag;
            }
        }
        return new StationTag(null, TagName.of(stationName), Map.of(stationName, StationTag.StationInfo.empty()));
    }

    public StationTag createOrGetStationTag(String name) {
        return this.createOrGetStationTag(TagName.of(name));
    }

    public StationTag createOrGetStationTag(TagName name) {
        UUID newId;
        Optional<StationTag> tag = this.getTagByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        StationTag newTag = new StationTag(newId, name);
        this.stationTags.put(newId, newTag);
        return newTag;
    }

    public StationTag registerStationTag(StationTag tag) {
        UUID newId;
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        tag.setId(newId);
        this.stationTags.put(newId, tag);
        return tag;
    }

    public Optional<StationTag> getTagByName(TagName name) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(name)) continue;
            return Optional.ofNullable(tag);
        }
        return Optional.empty();
    }

    public Optional<StationTag> getStationTag(UUID id) {
        return Optional.ofNullable(this.stationTagExists(id) ? this.stationTags.get(id) : null);
    }

    public boolean removeStationTag(String name) {
        return this.removeStationTag(TagName.of(name));
    }

    public boolean removeStationTag(TagName name) {
        return this.stationTags.values().removeIf(x -> x.getTagName().equals(name));
    }

    public StationTag removeStationTag(UUID id) {
        return this.stationTags.remove(id);
    }

    public List<StationTag> getAllStationTags() {
        return new ArrayList<StationTag>(this.stationTags.values());
    }

    public boolean trainGroupExists(String name) {
        return this.trainGroups.containsKey(name);
    }

    public TrainGroup createOrGetTrainGroup(String name) {
        Optional<TrainGroup> tag = this.getTrainGroup(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        TrainGroup newGroup = new TrainGroup(name);
        this.trainGroups.put(name, newGroup);
        return newGroup;
    }

    public Optional<TrainGroup> getTrainGroup(String name) {
        return Optional.ofNullable(this.trainGroupExists(name) ? this.trainGroups.get(name) : null);
    }

    public TrainGroup removeTrainGroup(String name) {
        return this.trainGroups.remove(name);
    }

    public ImmutableList<TrainGroup> getAllTrainGroups() {
        return ImmutableList.copyOf(this.trainGroups.values());
    }

    public boolean isTrainExcludedByUser(Train train, UserSettings settings) {
        if (TrainListener.data.get(train.id).getSections().isEmpty()) {
            return false;
        }
        for (TrainTravelSection section : TrainListener.data.get(train.id).getSections()) {
            if (!section.isUsable() || section.getTrainGroup().map(x -> settings.navigationExcludedTrainGroups.getValue().contains(x.getGroupName())).orElse(false).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainPrediction at, UserSettings settings) {
        return at.getSection().getTrainGroup().map(x -> !at.getSection().isUsable() || settings.navigationExcludedTrainGroups.getValue().contains(x.getGroupName())).orElse(false);
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainStop at, UserSettings settings) {
        TrainTravelSection section = TrainListener.data.get(train.id).getSectionByIndex(at.getSectionIndex());
        return section.getTrainGroup().map(x -> !section.isUsable() || settings.navigationExcludedTrainGroups.getValue().contains(x.getGroupName())).orElse(false);
    }

    public boolean isStationBlacklisted(GlobalStation station) {
        return this.isStationBlacklisted(station.name);
    }

    public boolean isStationBlacklisted(String name) {
        return this.stationBlacklist.contains(name);
    }

    public void blacklistStation(GlobalStation station) {
        this.blacklistStation(station.name);
    }

    public void blacklistStation(String stationName) {
        this.stationBlacklist.add(stationName);
    }

    public boolean removeStationFromBlacklist(GlobalStation station) {
        return this.removeStationFromBlacklist(station.name);
    }

    public boolean removeStationFromBlacklist(String stationName) {
        return this.stationBlacklist.removeIf(x -> x.equals(stationName));
    }

    public boolean isEntireStationTagBlacklisted(StationTag tag) {
        if (tag == null) {
            return true;
        }
        Set<String> names = tag.getAllStationNames();
        for (String name : names) {
            if (this.isStationBlacklisted(name)) continue;
            return false;
        }
        return !names.isEmpty();
    }

    public ImmutableList<String> getAllBlacklistedStations() {
        return ImmutableList.copyOf(this.stationBlacklist);
    }

    public boolean isTrainBlacklisted(Train train) {
        return this.isTrainBlacklisted(train.name.getString());
    }

    public boolean isTrainBlacklisted(String trainName) {
        return this.trainBlacklist.contains(trainName);
    }

    public void blacklistTrain(Train train) {
        this.blacklistTrain(train.name.getString());
    }

    public void blacklistTrain(String trainName) {
        this.trainBlacklist.add(trainName);
    }

    public boolean removeTrainFromBlacklist(Train train) {
        return this.removeTrainFromBlacklist(train.name.getString());
    }

    public boolean removeTrainFromBlacklist(String trainName) {
        return this.trainBlacklist.removeIf(x -> x.equals(trainName));
    }

    public ImmutableList<String> getAllBlacklistedTrains() {
        return ImmutableList.copyOf(this.trainBlacklist);
    }

    public boolean trainLineExists(String name) {
        return this.trainLines.containsKey(name);
    }

    public TrainLine createOrGetTrainLine(String name) {
        Optional<TrainLine> tag = this.getTrainLine(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        TrainLine newGroup = new TrainLine(name);
        this.trainLines.put(newGroup.getLineName(), newGroup);
        return newGroup;
    }

    public Optional<TrainLine> getTrainLine(String name) {
        return Optional.ofNullable(this.trainLineExists(name) ? this.trainLines.get(name) : null);
    }

    public TrainLine removeTrainLine(String name) {
        return this.trainLines.remove(name);
    }

    public ImmutableList<TrainLine> getAllTrainLines() {
        return ImmutableList.copyOf(this.trainLines.values());
    }
}

